/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComprobanteAnulado
extends ObjetoModeloSucesorValidable<Iva>
implements InformacionEditable<ComprobanteAnulado>,
Exportable,
Importable {
    private static final long serialVersionUID = -8134270393257994183L;
    public static final String C_TIPO_COMPROBANTE_ANULADO = "tipoComprobanteAnulado";
    public static final String C_ESTABLECIMIENTO = "establecimiento";
    public static final String C_PUNTO_EMISION = "puntoEmision";
    public static final String C_SECUENCIA_DESDE = "secuencialDesde";
    public static final String C_SECUENCIA_HASTA = "secuencialHasta";
    public static final String C_NUM_AUTORIZACION = "numAutorizacion";
    private static final String VALOR = "El valor ";
    private static final String MSG_ESTBLM = "Debe ingresar el valor de Establecimiento";
    private static final String MSG_REG_ESTBLM = "El valor Establecimiento debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ";
    private static final String MSG_EMISION = "Debe ingresar el valor de Punto de emisi\u00f3n";
    private static final String MSG_REG_EMISION = "El valor Punto de emisi\u00f3n debe ser solo n\u00fameros. Diferente de cero. 3 d\u00edgitos. ";
    private static final String MSG_SEC = "Debe ingresar el valor de Secuencial ";
    private static final String MSG_REG_SEC = "El valor Secuencial debe ser solo n\u00fameros. Diferente de cero. ";
    private static final String MSG_NUMAUT = "Debe ingresar el valor de No. autorizaci\u00f3n";
    private static final String MSG_REG_NUMAUT = "El valor No. autorizaci\u00f3n debe ser solo n\u00fameros. Diferente de cero.  M\u00ednimo 3 d\u00edgitos, m\u00e1ximo 49. ";
    private String tipoComprobanteAnulado;
    private String descripcionTipoComprobanteAnulado;
    private String establecimiento = "000";
    private String puntoEmision = "000";
    private String secuencialDesde = "0";
    private String secuencialHasta = "0";
    private String numAutorizacion = "000";

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (StringUtil.isNullOrEmpty((String)this.getTipoComprobanteAnulado())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de Comprobante");
        }
        if (StringUtil.isNullOrEmpty((String)this.getEstablecimiento())) {
            return resultado.fallarValidacion(MSG_ESTBLM);
        }
        if (!Pattern.matches("\\d{3}(?<!000)", this.getEstablecimiento())) {
            return resultado.fallarValidacion(MSG_REG_ESTBLM);
        }
        if (StringUtil.isNullOrEmpty((String)this.getPuntoEmision())) {
            return resultado.fallarValidacion(MSG_EMISION);
        }
        if (!Pattern.matches("\\d{3}(?<!000)", this.getPuntoEmision())) {
            return resultado.fallarValidacion(MSG_REG_EMISION);
        }
        if (StringUtil.isNullOrEmpty((String)this.getSecuencialDesde())) {
            return resultado.fallarValidacion("Debe ingresar el valor de Secuencial Desde");
        }
        if (!Pattern.matches("\\d{1,9}", this.getSecuencialDesde())) {
            return resultado.fallarValidacion("El valor Secuencial debe ser solo n\u00fameros. Diferente de cero. Desde");
        }
        if (StringUtil.isNullOrEmpty((String)this.getSecuencialHasta())) {
            return resultado.fallarValidacion("Debe ingresar el valor de Secuencial Hasta");
        }
        if (!Pattern.matches("\\d{1,9}", this.getSecuencialHasta())) {
            return resultado.fallarValidacion("El valor Secuencial debe ser solo n\u00fameros. Diferente de cero. Hasta");
        }
        if (!this.validarSecuenciaHasta(resultado).esEstadoExitoso()) {
            return resultado;
        }
        if (StringUtil.isNullOrEmpty((String)this.getNumAutorizacion())) {
            return resultado.fallarValidacion(MSG_NUMAUT);
        }
        if (!Pattern.matches("\\d{3,49}", this.getNumAutorizacion())) {
            return resultado.fallarValidacion(MSG_REG_NUMAUT);
        }
        if (this.validarNumAutorizacion(resultado).esEstadoFallido()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    private ResultadoValidacion validarSecuenciaHasta(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getSecuencialDesde()).compareTo(BigDecimal.ZERO) == 0 || Util.getBigDecimal(this.getSecuencialHasta()).compareTo(BigDecimal.ZERO) == 0) {
            return resultado.fallarValidacion("El valor secuencial desde y secuencial hasta deben ser diferente de cero");
        }
        if (Util.getDouble(this.getSecuencialDesde()) > Util.getDouble(this.getSecuencialHasta())) {
            return resultado.fallarValidacion("El n\u00famero de Secuencial desde no debe ser mayor a Secuencial hasta");
        }
        return resultado;
    }

    public ComprobanteAnulado crearCopiaEdicion() {
        ComprobanteAnulado copia = new ComprobanteAnulado();
        copia.setTipoComprobanteAnulado(this.tipoComprobanteAnulado);
        copia.setDescripcionTipoComprobanteAnulado(this.descripcionTipoComprobanteAnulado);
        copia.setEstablecimiento(this.establecimiento);
        copia.setPuntoEmision(this.puntoEmision);
        copia.setSecuencialDesde(this.secuencialDesde);
        copia.setSecuencialHasta(this.secuencialHasta);
        copia.setNumAutorizacion(this.numAutorizacion);
        copia.setPropietario((Iva)this.propietario);
        return copia;
    }

    public void actualizarInformacion(ComprobanteAnulado copiaEdicion) {
        this.setTipoComprobanteAnulado(copiaEdicion.getTipoComprobanteAnulado());
        this.setDescripcionTipoComprobanteAnulado(copiaEdicion.getDescripcionTipoComprobanteAnulado());
        this.setEstablecimiento(copiaEdicion.getEstablecimiento());
        this.setPuntoEmision(copiaEdicion.getPuntoEmision());
        this.setSecuencialDesde(copiaEdicion.getSecuencialDesde());
        this.setSecuencialHasta(copiaEdicion.getSecuencialHasta());
        this.setNumAutorizacion(copiaEdicion.getNumAutorizacion());
    }

    private ResultadoValidacion validarNumAutorizacion(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getNumAutorizacion()).compareTo(BigDecimal.ZERO) == 0) {
            return resultado.fallarValidacion(MSG_REG_NUMAUT);
        }
        return resultado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tipoComprobante");
        Element eValor = (Element)valorList.item(0);
        this.tipoComprobanteAnulado = eValor.getTextContent().trim();
        this.descripcionTipoComprobanteAnulado = String.valueOf(this.getTipoComprobanteAnulado()) + "-" + UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobanteAnulado());
        valorList = elemento.getElementsByTagName(C_ESTABLECIMIENTO);
        eValor = (Element)valorList.item(0);
        this.establecimiento = eValor.getTextContent();
        valorList = elemento.getElementsByTagName(C_PUNTO_EMISION);
        eValor = (Element)valorList.item(0);
        this.puntoEmision = eValor.getTextContent();
        valorList = elemento.getElementsByTagName("secuencialInicio");
        eValor = (Element)valorList.item(0);
        this.secuencialDesde = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("secuencialFin");
        eValor = (Element)valorList.item(0);
        this.secuencialHasta = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("autorizacion");
        eValor = (Element)valorList.item(0);
        this.numAutorizacion = eValor.getTextContent();
        return this;
    }

    public String getTipoComprobanteAnulado() {
        return this.tipoComprobanteAnulado;
    }

    public String getDescripcionTipoComprobanteAnulado() {
        return this.descripcionTipoComprobanteAnulado;
    }

    public String getEstablecimiento() {
        return this.establecimiento;
    }

    public String getPuntoEmision() {
        return this.puntoEmision;
    }

    public String getSecuencialDesde() {
        return this.secuencialDesde;
    }

    public String getSecuencialHasta() {
        return this.secuencialHasta;
    }

    public String getNumAutorizacion() {
        return this.numAutorizacion;
    }

    public void setTipoComprobanteAnulado(String tipoComprobanteAnulado) {
        String oldValue = this.tipoComprobanteAnulado;
        this.tipoComprobanteAnulado = tipoComprobanteAnulado;
        this.firePropertyChange(C_TIPO_COMPROBANTE_ANULADO, oldValue, this.tipoComprobanteAnulado);
    }

    public void setDescripcionTipoComprobanteAnulado(String descripcionTipoComprobanteAnulado) {
        this.descripcionTipoComprobanteAnulado = descripcionTipoComprobanteAnulado;
    }

    public void setEstablecimiento(String establecimiento) {
        String oldValue = this.establecimiento;
        this.establecimiento = establecimiento;
        this.firePropertyChange(C_ESTABLECIMIENTO, oldValue, this.establecimiento);
    }

    public void setPuntoEmision(String puntoEmision) {
        String oldValue = this.puntoEmision;
        this.puntoEmision = puntoEmision;
        this.firePropertyChange(C_PUNTO_EMISION, oldValue, this.puntoEmision);
    }

    public void setSecuencialDesde(String secuencialDesde) {
        String oldValue = this.secuencialDesde;
        this.secuencialDesde = secuencialDesde;
        this.firePropertyChange(C_SECUENCIA_DESDE, oldValue, this.secuencialDesde);
    }

    public void setSecuencialHasta(String secuencialHasta) {
        String oldValue = this.secuencialHasta;
        this.secuencialHasta = secuencialHasta;
        this.firePropertyChange(C_SECUENCIA_HASTA, oldValue, this.secuencialHasta);
    }

    public void setNumAutorizacion(String numAutorizacion) {
        String oldValue = this.numAutorizacion;
        this.numAutorizacion = numAutorizacion;
        this.firePropertyChange(C_NUM_AUTORIZACION, oldValue, this.numAutorizacion);
    }

    public String getSerial() {
        return String.valueOf(this.establecimiento) + "-" + this.puntoEmision;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.establecimiento == null ? 0 : this.establecimiento.hashCode());
        result = 31 * result + (this.numAutorizacion == null ? 0 : this.numAutorizacion.hashCode());
        result = 31 * result + (this.puntoEmision == null ? 0 : this.puntoEmision.hashCode());
        result = 31 * result + (this.secuencialDesde == null ? 0 : this.secuencialDesde.hashCode());
        result = 31 * result + (this.secuencialHasta == null ? 0 : this.secuencialHasta.hashCode());
        result = 31 * result + (this.tipoComprobanteAnulado == null ? 0 : this.tipoComprobanteAnulado.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComprobanteAnulado)) {
            return false;
        }
        ComprobanteAnulado other = (ComprobanteAnulado)((Object)obj);
        if (this.establecimiento == null ? other.establecimiento != null : !this.establecimiento.equals(other.establecimiento)) {
            return false;
        }
        if (this.numAutorizacion == null ? other.numAutorizacion != null : !this.numAutorizacion.equals(other.numAutorizacion)) {
            return false;
        }
        if (this.puntoEmision == null ? other.puntoEmision != null : !this.puntoEmision.equals(other.puntoEmision)) {
            return false;
        }
        if (this.secuencialDesde == null ? other.secuencialDesde != null : !this.secuencialDesde.equals(other.secuencialDesde)) {
            return false;
        }
        if (this.secuencialHasta == null ? other.secuencialHasta != null : !this.secuencialHasta.equals(other.secuencialHasta)) {
            return false;
        }
        return !(this.tipoComprobanteAnulado == null ? other.tipoComprobanteAnulado != null : !this.tipoComprobanteAnulado.equals(other.tipoComprobanteAnulado));
    }

    public Element exportar(Document documento, Element elemento) {
        Element eleDetAnl = documento.createElement("detalleAnulados");
        Element emDtAn = documento.createElement("tipoComprobante");
        emDtAn.setTextContent(this.getTipoComprobanteAnulado());
        eleDetAnl.appendChild(emDtAn);
        emDtAn = documento.createElement(C_ESTABLECIMIENTO);
        emDtAn.setTextContent(this.getEstablecimiento());
        eleDetAnl.appendChild(emDtAn);
        emDtAn = documento.createElement(C_PUNTO_EMISION);
        emDtAn.setTextContent(this.getPuntoEmision());
        eleDetAnl.appendChild(emDtAn);
        emDtAn = documento.createElement("secuencialInicio");
        emDtAn.setTextContent(this.getSecuencialDesde());
        eleDetAnl.appendChild(emDtAn);
        emDtAn = documento.createElement("secuencialFin");
        emDtAn.setTextContent(this.getSecuencialHasta());
        eleDetAnl.appendChild(emDtAn);
        emDtAn = documento.createElement("autorizacion");
        emDtAn.setTextContent(this.getNumAutorizacion());
        eleDetAnl.appendChild(emDtAn);
        return eleDetAnl;
    }
}

